<x-app-layout>
    <x-slot name="header">
        Blog
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($blog->id)
                        Edit Blog
                        @else
                        Add New Blog
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($blog->id)
                        {{ route('admin.blog.update', $blog->id) }}
                    @else
                        {{ route('admin.blog.store') }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($blog->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="title">Blog Title :</label>
                            <div class="">
                                <input required type="search" class="form-control @error('title') is-invalid @enderror"
                                    name="title" value="{{ old('title', $blog->title) }}" placeholder="Blog Title">
                            </div>
                            @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <div class="col-lg-4">
                                <label class="form-label" id="category_id">Category :</label>
                                <div class="">
                                    <select required name="category_id"
                                        class="form-control @error('category_id') is-invalid @enderror">
                                        <option value="">Select Category</option>
                                        @foreach ($categories as $category)
                                        <option value="{{ $category->id }}" @selected($category->id == old('category_id', $blog->category_id))>{{ $category->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('category_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-lg-4">
                                <label class="form-label" id="destination_id">Destination :</label>
                                <div class="">
                                    <select name="destination_id"
                                        class="form-control @error('destination_id') is-invalid @enderror">
                                        <option value="">Select Destination</option>
                                        @foreach ($destinations as $destination)
                                        <option value="{{ $destination->id }}" @selected($destination->id == old('destination_id', $blog->destination_id))>{{ $destination->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('destination_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="thumbnail">Thumbnail :</label>
                            <div class="">
                                <input  @if(!isset($blog->id))required @endif type="file" class="form-control @error('thumbnail') is-invalid @enderror"
                                    name="thumbnail" value="{{ old('thumbnail', $blog->thumbnail) }}"
                                    placeholder="Blog thumbnail" accept=".jpg, .png, image/jpeg, image/png">
                            </div>
                            @error('thumbnail')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="content">Blog Details:</label>
                            <div class="">
                                <textarea required name="content" class="content @error('content') is-invalid @enderror"
                                    placeholder="Blog Content">{{ old('content', $blog->content) }}</textarea>
                            </div>
                            @error('content')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $blog->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('admin.blog.index')}}" class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <x-slot name="script">
        <script src="{{asset('backend/plugins/wysiwyag/jquery.richtext.js')}}"></script>
        <script src="{{asset('backend/plugins/wysiwyag/wysiwyag.js')}}"></script>
        <script>
            $(document).ready(function () {
            });
        </script>
    </x-slot>

</x-app-layout>
